// author: RuanShengQiang 
// date: 2017/6/21
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define PI 3.141592653589f

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 p = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	
	float flashPhase = 0.8f; 
	float flashIntensity = 1.0f;
	float flashZoomEffect = 0.5f;
	 
	const vec3 flashColor = (vec3)(0.8f, 0.8f, 0.8f);
	const float flashVelocity = 3.0f;
	
	float intensity = mix(1.0f, 2.0f*distance(p, (vec2)(0.5f, 0.5f)), flashZoomEffect) * flashIntensity * pow(smoothstep(flashPhase, 0.0f, distance(0.5f, progress)), flashVelocity);
	vec4 c = mix(INPUT(input1, param, p), INPUT(input2, param, p), (vec4)(smoothstep(0.5f*(1.0f-flashPhase), 0.5f*(1.0f+flashPhase), progress)) );
	c += intensity * (vec4)(flashColor, 1.0f);
  
	write_imagef(dstImg, (int2)(w, textH - h -1), c);
}